-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: localhost:3306
-- Tempo de geração: 26-Nov-2025 às 10:53
-- Versão do servidor: 8.0.37
-- versão do PHP: 8.1.28

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Banco de dados: `giselle_ki`
--

-- --------------------------------------------------------

--
-- Estrutura da tabela `addresses`
--

CREATE TABLE `addresses` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `type` enum('billing','shipping') DEFAULT 'billing',
  `name` varchar(100) NOT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `address_line1` varchar(200) NOT NULL,
  `address_line2` varchar(200) DEFAULT NULL,
  `city` varchar(100) NOT NULL,
  `state` varchar(100) NOT NULL,
  `postal_code` varchar(20) NOT NULL,
  `country` varchar(100) NOT NULL DEFAULT 'Brasil',
  `is_default` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estrutura da tabela `affiliate_commissions`
--

CREATE TABLE `affiliate_commissions` (
  `id` int NOT NULL,
  `product_id` int NOT NULL,
  `commission_type` enum('percentage','fixed') DEFAULT 'percentage',
  `commission_value` decimal(10,2) NOT NULL,
  `min_sales` int DEFAULT '0',
  `max_sales` int DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `status` enum('active','inactive') DEFAULT 'active',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Extraindo dados da tabela `affiliate_commissions`
--

INSERT INTO `affiliate_commissions` (`id`, `product_id`, `commission_type`, `commission_value`, `min_sales`, `max_sales`, `start_date`, `end_date`, `status`, `created_at`, `updated_at`) VALUES
(0, 1, 'percentage', 30.00, 0, 0, NULL, NULL, 'active', '2025-11-25 21:01:14', '2025-11-25 21:01:14'),
(0, 2, 'percentage', 30.00, 0, 0, NULL, NULL, 'active', '2025-11-25 21:20:53', '2025-11-25 21:20:53');

-- --------------------------------------------------------

--
-- Estrutura da tabela `affiliate_dashboard`
--

CREATE TABLE `affiliate_dashboard` (
  `affiliate_id` int DEFAULT NULL,
  `affiliate_name` varchar(100) DEFAULT NULL,
  `total_sales` bigint DEFAULT NULL,
  `total_sales_value` decimal(32,2) DEFAULT NULL,
  `total_commissions` decimal(32,2) DEFAULT NULL,
  `promoted_products` bigint DEFAULT NULL,
  `approved_affiliations` bigint DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estrutura da tabela `affiliate_links`
--

CREATE TABLE `affiliate_links` (
  `id` int NOT NULL,
  `affiliate_id` int NOT NULL,
  `product_id` int NOT NULL,
  `affiliate_code` varchar(50) NOT NULL,
  `link_url` text NOT NULL,
  `click_count` int DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Extraindo dados da tabela `affiliate_links`
--

INSERT INTO `affiliate_links` (`id`, `affiliate_id`, `product_id`, `affiliate_code`, `link_url`, `click_count`, `created_at`, `updated_at`) VALUES
(1, 5, 1, '', 'https://scriptschool.com.br/digital/track_click.php?product_id=1&affiliate=5', 10, '2025-11-25 21:03:39', '2025-11-26 01:14:34'),
(2, 5, 1, '793fb353c0b6', 'https://scriptschool.com.br/digital/track_click.php?product_id=1&affiliate=5', 8, '2025-11-25 21:04:04', '2025-11-26 01:09:19'),
(3, 5, 1, '8a31d2f97170', 'https://scriptschool.com.br/digital/track_click.php?product_id=1&affiliate=5', 8, '2025-11-25 21:04:42', '2025-11-26 01:09:19'),
(4, 5, 1, 'a5b9a848c3f4', 'https://scriptschool.com.br/digital/track_click.php?product_id=1&affiliate=5', 8, '2025-11-25 21:05:19', '2025-11-26 01:09:19'),
(5, 5, 1, 'c65732063e2b', 'https://scriptschool.com.br/digital/track_click.php?product_id=1&affiliate=5', 8, '2025-11-25 21:06:01', '2025-11-26 01:09:19'),
(6, 5, 1, '71a4660b5ffa', 'https://scriptschool.com.br/digital/track_click.php?product_id=1&affiliate=5', 8, '2025-11-25 21:06:01', '2025-11-26 01:09:19'),
(7, 5, 1, '114ce566cdb2', 'https://scriptschool.com.br/digital/track_click.php?product_id=1&affiliate=5', 8, '2025-11-25 21:08:20', '2025-11-26 01:09:19'),
(8, 5, 1, '89456dcd0aca', 'https://scriptschool.com.br/digital/track_click.php?product_id=1&affiliate=5', 8, '2025-11-25 21:08:21', '2025-11-26 01:09:19'),
(9, 5, 1, '83407359c9f6', 'https://scriptschool.com.br/digital/track_click.php?product_id=1&affiliate=5', 8, '2025-11-25 21:11:07', '2025-11-26 01:09:19'),
(10, 5, 1, '2bcdb30ac283', 'https://scriptschool.com.br/digital/track_click.php?product_id=1&affiliate=5', 8, '2025-11-25 21:11:07', '2025-11-26 01:09:19'),
(11, 5, 1, 'f3a19433f6d1', 'https://scriptschool.com.br/digital/track_click.php?product_id=1&affiliate=5', 8, '2025-11-25 21:18:14', '2025-11-26 01:09:19'),
(12, 5, 2, '', 'https://scriptschool.com.br/digital/track_click.php?product_id=2&affiliate=5', 7, '2025-11-25 21:21:14', '2025-11-26 01:13:52'),
(13, 5, 2, '26f05da37793', 'https://scriptschool.com.br/digital/track_click.php?product_id=2&affiliate=5', 6, '2025-11-25 21:21:42', '2025-11-26 01:09:19'),
(14, 5, 2, '7416bdb13f54', 'https://scriptschool.com.br/digital/track_click.php?product_id=2&affiliate=5', 6, '2025-11-25 21:22:04', '2025-11-26 01:09:19'),
(15, 5, 2, 'b68919e309a9', 'https://scriptschool.com.br/digital/track_click.php?product_id=2&affiliate=5', 6, '2025-11-26 00:44:55', '2025-11-26 01:09:19'),
(16, 5, 2, '6c9caffe72d1', 'https://scriptschool.com.br/digital/track_click.php?product_id=2&affiliate=5', 6, '2025-11-26 00:49:57', '2025-11-26 01:09:19'),
(17, 5, 1, 'novo_codigo', 'https://...', 0, '2025-11-26 01:12:49', '2025-11-26 01:12:49'),
(18, 5, 1, 'novo_codigo', 'https://...', 0, '2025-11-26 01:12:49', '2025-11-26 01:12:49'),
(19, 7, 2, '00ecf49e5cca', 'https://scriptschool.com.br/digital/track_click.php?product_id=2&affiliate=7&code=00ecf49e5cca', 2, '2025-11-26 01:20:16', '2025-11-26 12:07:37'),
(20, 7, 1, 'b2e8a446946e', 'https://scriptschool.com.br/digital/track_click.php?product_id=1&affiliate=7&code=b2e8a446946e', 3, '2025-11-26 01:20:53', '2025-11-26 12:06:26'),
(21, 7, 2, '00ecf49e5cca', 'https://scriptschool.com.br/digital/track_click.php?product_id=2&affiliate=7&code=00ecf49e5cca', 0, '2025-11-26 12:06:55', '2025-11-26 12:07:07');

-- --------------------------------------------------------

--
-- Estrutura da tabela `affiliate_payouts`
--

CREATE TABLE `affiliate_payouts` (
  `id` int NOT NULL,
  `affiliate_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `commission_rate` decimal(5,2) NOT NULL,
  `status` enum('pending','paid','cancelled') DEFAULT 'pending',
  `payout_method` enum('bank_transfer','pix','credit') DEFAULT NULL,
  `payout_reference` varchar(100) DEFAULT NULL,
  `paid_at` datetime DEFAULT NULL,
  `paid_by` int DEFAULT NULL,
  `notes` text,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estrutura da tabela `affiliate_withdrawals`
--

CREATE TABLE `affiliate_withdrawals` (
  `id` int NOT NULL,
  `affiliate_id` int NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `net_amount` decimal(10,2) NOT NULL,
  `fee_amount` decimal(10,2) NOT NULL DEFAULT '2.10',
  `status` enum('pending','approved','rejected','paid') DEFAULT 'pending',
  `payment_method` enum('pix','bank_transfer') NOT NULL,
  `payment_details` json DEFAULT NULL,
  `admin_notes` text,
  `affiliate_notes` text,
  `approved_at` datetime DEFAULT NULL,
  `approved_by` int DEFAULT NULL,
  `paid_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estrutura da tabela `categories`
--

CREATE TABLE `categories` (
  `id` int NOT NULL,
  `name` varchar(100) NOT NULL,
  `slug` varchar(100) NOT NULL,
  `description` text,
  `image_url` varchar(500) DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `status` enum('active','inactive') DEFAULT 'active',
  `sort_order` int DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Extraindo dados da tabela `categories`
--

INSERT INTO `categories` (`id`, `name`, `slug`, `description`, `image_url`, `parent_id`, `status`, `sort_order`, `created_at`, `updated_at`) VALUES
(1, 'Cursos Online', 'cursos-online', 'Cursos em formato digital para aprendizado online', NULL, NULL, 'active', 1, '2025-11-18 13:25:25', '2025-11-18 13:25:25'),
(2, 'E-books', 'e-books', 'Livros digitais sobre diversos temas', NULL, NULL, 'active', 2, '2025-11-18 13:25:25', '2025-11-18 13:25:25'),
(3, 'Software', 'software', 'Programas e aplicativos digitais', NULL, NULL, 'active', 3, '2025-11-18 13:25:25', '2025-11-18 13:25:25'),
(4, 'Templates', 'templates', 'Modelos prontos para diversos usos', NULL, NULL, 'active', 4, '2025-11-18 13:25:25', '2025-11-18 13:25:25'),
(5, 'Áudio', 'audio', 'Músicas, podcasts e sons', NULL, NULL, 'active', 5, '2025-11-18 13:25:25', '2025-11-18 13:25:25'),
(6, 'Vídeo', 'video', 'Vídeos educativos e entretenimento', NULL, NULL, 'active', 6, '2025-11-18 13:25:25', '2025-11-18 13:25:25');

-- --------------------------------------------------------

--
-- Estrutura da tabela `checkout_logs`
--

CREATE TABLE `checkout_logs` (
  `id` int NOT NULL,
  `product_id` int NOT NULL,
  `gateway` varchar(20) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `affiliate_id` int DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Extraindo dados da tabela `checkout_logs`
--

INSERT INTO `checkout_logs` (`id`, `product_id`, `gateway`, `amount`, `affiliate_id`, `ip_address`, `created_at`) VALUES
(0, 1, 'mercadopago', 11.00, 5, '189.127.255.217', '2025-11-25 18:04:43'),
(0, 1, 'mercadopago', 11.00, 5, '189.127.255.217', '2025-11-25 18:05:20'),
(0, 1, 'mercadopago', 11.00, 5, '189.127.255.217', '2025-11-25 18:06:01'),
(0, 1, 'mercadopago', 11.00, 5, '189.127.255.217', '2025-11-25 18:06:02'),
(0, 1, 'mercadopago', 11.00, 5, '189.127.255.217', '2025-11-25 18:08:20'),
(0, 1, 'mercadopago', 11.00, 5, '189.127.255.217', '2025-11-25 18:08:21'),
(0, 1, 'mercadopago', 11.00, 5, '189.127.255.217', '2025-11-25 18:11:07'),
(0, 1, 'mercadopago', 11.00, 5, '189.127.255.217', '2025-11-25 18:11:08'),
(0, 1, 'mercadopago', 11.00, 5, '189.127.255.217', '2025-11-25 18:18:15'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 18:22:05'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 21:44:56'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 21:49:58'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 21:53:43'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 21:53:44'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 21:54:28'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 21:54:29'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 21:55:18'),
(0, 1, 'mercadopago', 11.00, 5, '189.127.255.217', '2025-11-25 21:58:44'),
(0, 1, 'mercadopago', 11.00, 5, '189.127.255.217', '2025-11-25 21:58:45'),
(0, 1, 'mercadopago', 11.00, 5, '189.127.255.217', '2025-11-25 21:59:14'),
(0, 1, 'mercadopago', 11.00, 5, '189.127.255.217', '2025-11-25 21:59:15'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 22:02:07'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 22:02:08'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 22:02:38'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 22:02:39'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 22:03:06'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 22:03:07'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 22:04:23'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 22:04:24'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 22:08:10'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 22:08:10'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 22:08:50'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 22:08:51'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 22:09:19'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 22:09:20'),
(0, 1, 'mercadopago', 11.00, 5, '189.127.255.217', '2025-11-25 22:13:26'),
(0, 1, 'mercadopago', 11.00, 5, '189.127.255.217', '2025-11-25 22:13:28'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 22:13:53'),
(0, 2, 'mercadopago', 42.00, 5, '189.127.255.217', '2025-11-25 22:13:54'),
(0, 1, 'mercadopago', 11.00, 5, '189.127.255.217', '2025-11-25 22:14:35'),
(0, 1, 'mercadopago', 11.00, 5, '189.127.255.217', '2025-11-25 22:14:35'),
(0, 1, 'mercadopago', 11.00, 7, '189.127.255.217', '2025-11-25 22:21:21'),
(0, 1, 'mercadopago', 11.00, 7, '189.127.255.217', '2025-11-25 22:48:47'),
(0, 1, 'mercadopago', 11.00, 7, '189.127.255.217', '2025-11-25 22:49:39'),
(0, 1, 'mercadopago', 11.00, NULL, '189.127.255.217', '2025-11-26 08:30:19'),
(0, 2, 'mercadopago', 42.00, NULL, '189.127.255.217', '2025-11-26 08:38:43'),
(0, 2, 'mercadopago', 42.00, 7, '189.127.255.217', '2025-11-26 09:07:25'),
(0, 2, 'mercadopago', 42.00, 7, '189.127.255.217', '2025-11-26 09:07:37'),
(0, 2, 'mercadopago', 42.00, NULL, '189.127.255.217', '2025-11-26 09:33:47'),
(0, 1, 'mercadopago', 11.00, NULL, '189.127.255.217', '2025-11-26 10:13:37'),
(0, 1, 'mercadopago', 11.00, NULL, '189.127.255.217', '2025-11-26 10:20:57'),
(0, 1, 'mercadopago', 11.00, NULL, '189.127.255.217', '2025-11-26 10:45:57');

-- --------------------------------------------------------

--
-- Estrutura da tabela `click_logs`
--

CREATE TABLE `click_logs` (
  `id` int NOT NULL,
  `link_id` int DEFAULT NULL,
  `product_id` int NOT NULL,
  `affiliate_id` int NOT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text,
  `clicked_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Extraindo dados da tabela `click_logs`
--

INSERT INTO `click_logs` (`id`, `link_id`, `product_id`, `affiliate_id`, `ip_address`, `user_agent`, `clicked_at`) VALUES
(0, 0, 1, 5, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-25 21:04:42'),
(0, 0, 1, 5, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-25 21:05:19'),
(0, 0, 1, 5, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-25 21:06:01'),
(0, 0, 1, 5, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-25 21:06:01'),
(0, 0, 1, 5, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-25 21:08:20'),
(0, 0, 1, 5, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-25 21:08:21'),
(0, 0, 1, 5, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-25 21:11:07'),
(0, 0, 1, 5, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-25 21:11:07'),
(0, 0, 1, 5, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-25 21:18:14'),
(0, 0, 2, 5, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-25 21:22:04'),
(0, 0, 2, 5, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-26 00:44:55'),
(0, 0, 2, 5, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-26 00:49:57'),
(0, NULL, 2, 5, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-26 00:53:42'),
(0, NULL, 2, 5, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-26 00:53:43'),
(0, NULL, 2, 5, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-26 00:54:28'),
(0, NULL, 2, 5, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-26 00:54:28'),
(0, NULL, 2, 5, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-26 00:55:17'),
(0, 1, 1, 5, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-26 01:13:25'),
(0, 12, 2, 5, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-26 01:13:52'),
(0, 1, 1, 5, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-26 01:14:34'),
(0, 20, 1, 7, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-26 01:21:20'),
(0, 20, 1, 7, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-26 01:48:46'),
(0, 20, 1, 7, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-26 01:49:38'),
(0, 19, 2, 7, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-26 12:07:25'),
(0, 19, 2, 7, '189.127.255.217', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-11-26 12:07:37');

-- --------------------------------------------------------

--
-- Estrutura da tabela `coupons`
--

CREATE TABLE `coupons` (
  `id` int NOT NULL,
  `code` varchar(50) NOT NULL,
  `description` text,
  `discount_type` enum('percentage','fixed') DEFAULT 'percentage',
  `discount_value` decimal(10,2) NOT NULL,
  `min_order_value` decimal(10,2) DEFAULT '0.00',
  `max_discount_amount` decimal(10,2) DEFAULT NULL,
  `usage_limit` int DEFAULT '0',
  `used_count` int DEFAULT '0',
  `user_limit` int DEFAULT '0',
  `valid_from` datetime DEFAULT NULL,
  `valid_until` datetime DEFAULT NULL,
  `applicable_to` enum('all','specific_products','specific_categories') DEFAULT 'all',
  `status` enum('active','inactive','expired') DEFAULT 'active',
  `created_by` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estrutura da tabela `coupon_categories`
--

CREATE TABLE `coupon_categories` (
  `id` int NOT NULL,
  `coupon_id` int NOT NULL,
  `category_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estrutura da tabela `coupon_products`
--

CREATE TABLE `coupon_products` (
  `id` int NOT NULL,
  `coupon_id` int NOT NULL,
  `product_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estrutura da tabela `coupon_usage`
--

CREATE TABLE `coupon_usage` (
  `id` int NOT NULL,
  `coupon_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `customer_email` varchar(150) NOT NULL,
  `discount_amount` decimal(10,2) NOT NULL,
  `used_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estrutura da tabela `downloads`
--

CREATE TABLE `downloads` (
  `id` int NOT NULL,
  `sale_id` int NOT NULL,
  `product_id` int NOT NULL,
  `customer_email` varchar(150) NOT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text,
  `download_token` varchar(100) DEFAULT NULL,
  `token_expires_at` datetime DEFAULT NULL,
  `downloaded_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Extraindo dados da tabela `downloads`
--

INSERT INTO `downloads` (`id`, `sale_id`, `product_id`, `customer_email`, `ip_address`, `user_agent`, `download_token`, `token_expires_at`, `downloaded_at`) VALUES
(0, 0, 2, 'test_user_80507629@testuser.com', NULL, NULL, 'fe9dc43e8fc19866ea1418f4403e465c5c6bd386e80e58505772dc718b00d28d', '2025-12-26 09:35:26', '2025-11-26 12:35:26'),
(1, 1001, 2, 'test_user_80507629@testuser.com', '192.168.1.1', 'Mozilla/5.0...', 'fe9dc43e8fc19866ea1418f4403e465c5c6bd386e80e58505772dc718b00d28d', '2025-12-26 09:35:26', '2025-11-26 15:35:26'),
(0, 0, 1, 'test_user_80507629@testuser.com', NULL, NULL, 'c3f039932caeae768d3b2509c5ffa40ab867180ecb857fa49902ab62ccd1eca9', '2025-12-26 10:13:54', '2025-11-26 13:13:54'),
(0, 3, 1, 'test_user_80507629@testuser.com', NULL, NULL, 'c78548b5f25e72e4c979ba0274e3039d4a794f5aa247f2d864b00f6ac25c0b7c', '2025-12-26 10:21:10', '2025-11-26 13:21:10'),
(0, 4, 1, 'test_user_80507629@testuser.com', NULL, NULL, 'e6dab1d9db2de1ff7528768397691d0a6e67b7279418ca3d5f7f125d6bd5f53a', '2025-12-26 10:48:53', '2025-11-26 13:48:53');

-- --------------------------------------------------------

--
-- Estrutura da tabela `download_logs`
--

CREATE TABLE `download_logs` (
  `id` int NOT NULL,
  `sale_id` int NOT NULL,
  `product_id` int NOT NULL,
  `affiliate_id` int DEFAULT NULL,
  `customer_email` varchar(150) NOT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text,
  `downloaded_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estrutura da tabela `notifications`
--

CREATE TABLE `notifications` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `title` varchar(200) NOT NULL,
  `message` text NOT NULL,
  `type` enum('info','success','warning','error') DEFAULT 'info',
  `related_type` enum('sale','product','affiliate','payout','system') DEFAULT 'system',
  `related_id` int DEFAULT NULL,
  `is_read` tinyint(1) DEFAULT '0',
  `action_url` varchar(500) DEFAULT NULL,
  `sent_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `read_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estrutura da tabela `payments`
--

CREATE TABLE `payments` (
  `id` int NOT NULL,
  `sale_id` int NOT NULL,
  `payment_gateway` varchar(50) NOT NULL,
  `gateway_transaction_id` varchar(100) DEFAULT NULL,
  `gateway_order_id` varchar(100) DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `amount` decimal(10,2) NOT NULL,
  `net_amount` decimal(10,2) DEFAULT NULL,
  `fee_amount` decimal(10,2) DEFAULT NULL,
  `status` enum('pending','approved','denied','refunded','chargeback') DEFAULT 'pending',
  `payment_data` json DEFAULT NULL,
  `gateway_response` text,
  `processed_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Extraindo dados da tabela `payments`
--

INSERT INTO `payments` (`id`, `sale_id`, `payment_gateway`, `gateway_transaction_id`, `gateway_order_id`, `payment_method`, `amount`, `net_amount`, `fee_amount`, `status`, `payment_data`, `gateway_response`, `processed_at`, `created_at`, `updated_at`) VALUES
(0, 0, 'mercadopago', '1342741509', NULL, NULL, 42.00, NULL, NULL, 'approved', NULL, NULL, '2025-11-26 09:35:26', '2025-11-26 12:35:26', '2025-11-26 12:35:26'),
(0, 0, 'mercadopago', '1325492962', NULL, NULL, 11.00, NULL, NULL, 'approved', NULL, NULL, '2025-11-26 10:13:54', '2025-11-26 13:13:54', '2025-11-26 13:13:54'),
(0, 3, 'mercadopago', '1325492480', NULL, NULL, 11.00, NULL, NULL, 'approved', NULL, NULL, '2025-11-26 10:21:10', '2025-11-26 13:21:10', '2025-11-26 13:21:10'),
(0, 4, 'mercadopago', '1325493248', NULL, NULL, 11.00, NULL, NULL, 'approved', NULL, NULL, '2025-11-26 10:48:53', '2025-11-26 13:48:53', '2025-11-26 13:48:53');

-- --------------------------------------------------------

--
-- Estrutura da tabela `payments_simulated`
--

CREATE TABLE `payments_simulated` (
  `id` int NOT NULL,
  `product_id` int NOT NULL,
  `affiliate_id` int DEFAULT NULL,
  `external_reference` varchar(100) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `card_last_digits` varchar(4) DEFAULT NULL,
  `status` varchar(20) DEFAULT 'approved',
  `payment_date` datetime DEFAULT CURRENT_TIMESTAMP,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estrutura da tabela `producer_dashboard`
--

CREATE TABLE `producer_dashboard` (
  `producer_id` int DEFAULT NULL,
  `producer_name` varchar(100) DEFAULT NULL,
  `total_products` bigint DEFAULT NULL,
  `active_products` bigint DEFAULT NULL,
  `total_sales` decimal(32,0) DEFAULT NULL,
  `total_revenue` decimal(32,2) DEFAULT NULL,
  `average_sale_value` decimal(14,6) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estrutura da tabela `producer_withdrawals`
--

CREATE TABLE `producer_withdrawals` (
  `id` int NOT NULL,
  `producer_id` int NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `net_amount` decimal(10,2) NOT NULL,
  `fee_amount` decimal(10,2) DEFAULT '2.10',
  `status` enum('pending','approved','rejected','paid') DEFAULT 'pending',
  `payment_method` enum('pix','bank_transfer') NOT NULL,
  `payment_details` json DEFAULT NULL,
  `admin_notes` text,
  `producer_notes` text,
  `approved_at` datetime DEFAULT NULL,
  `approved_by` int DEFAULT NULL,
  `paid_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estrutura da tabela `products`
--

CREATE TABLE `products` (
  `id` int NOT NULL,
  `producer_id` int NOT NULL,
  `category_id` int DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `slug` varchar(200) NOT NULL,
  `description` text,
  `short_description` text,
  `price` decimal(10,2) NOT NULL,
  `compare_price` decimal(10,2) DEFAULT NULL,
  `cost_price` decimal(10,2) DEFAULT NULL,
  `image_url` varchar(500) DEFAULT NULL,
  `image_path` varchar(500) DEFAULT NULL,
  `digital_file_url` varchar(500) DEFAULT NULL,
  `digital_file_name` varchar(200) DEFAULT NULL,
  `file_original_name` varchar(255) DEFAULT NULL,
  `file_path` varchar(500) DEFAULT NULL,
  `file_mime_type` varchar(100) DEFAULT NULL,
  `file_size` int DEFAULT NULL,
  `access_hash` varchar(100) DEFAULT NULL,
  `access_type` enum('instant','manual') DEFAULT 'instant',
  `download_limit` int DEFAULT '3',
  `download_expiry_days` int DEFAULT '30',
  `featured` tinyint(1) DEFAULT '0',
  `status` enum('draft','active','inactive','out_of_stock') DEFAULT 'draft',
  `tags` varchar(500) DEFAULT NULL,
  `seo_title` varchar(200) DEFAULT NULL,
  `seo_description` text,
  `seo_keywords` varchar(300) DEFAULT NULL,
  `view_count` int DEFAULT '0',
  `sale_count` int DEFAULT '0',
  `weight` decimal(8,2) DEFAULT NULL,
  `dimensions` varchar(100) DEFAULT NULL,
  `requires_shipping` tinyint(1) DEFAULT '0',
  `is_digital` tinyint(1) DEFAULT '1',
  `allow_affiliates` tinyint(1) DEFAULT '1',
  `affiliate_approval` enum('auto','manual') DEFAULT 'auto',
  `max_affiliates` int DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Extraindo dados da tabela `products`
--

INSERT INTO `products` (`id`, `producer_id`, `category_id`, `name`, `slug`, `description`, `short_description`, `price`, `compare_price`, `cost_price`, `image_url`, `image_path`, `digital_file_url`, `digital_file_name`, `file_original_name`, `file_path`, `file_mime_type`, `file_size`, `access_hash`, `access_type`, `download_limit`, `download_expiry_days`, `featured`, `status`, `tags`, `seo_title`, `seo_description`, `seo_keywords`, `view_count`, `sale_count`, `weight`, `dimensions`, `requires_shipping`, `is_digital`, `allow_affiliates`, `affiliate_approval`, `max_affiliates`, `created_at`, `updated_at`) VALUES
(1, 2, 1, 'curso de ti', 'curso-de-ti-1764104472', 'aprenda a curso de computacao', NULL, 11.00, NULL, NULL, 'https://via.placeholder.com/300x200?text=Produto+Teste', 'product_1_1764104472.png', NULL, NULL, 'product_10_1763946843.png', 'file_1_1764104473.png', NULL, 1023333, NULL, 'instant', 3, 30, 0, 'active', NULL, NULL, NULL, NULL, 0, 3, NULL, NULL, 0, 1, 1, 'auto', 0, '2025-11-25 21:01:12', '2025-11-26 13:48:53'),
(2, 2, 2, 'curso de pamonha', 'curso-de-pamonha-1764105650', 'aprenda a fazer as melhores pamonhas', NULL, 42.00, NULL, NULL, 'https://via.placeholder.com/300x200?text=Curso+Bolo', 'product_2_1764105650.png', NULL, NULL, 'ChatGPT Image 22_10_2025, 08_21_03.png', 'file_2_1764105652.png', NULL, 1259341, NULL, 'instant', 3, 30, 0, 'active', NULL, NULL, NULL, NULL, 0, 1, NULL, NULL, 0, 1, 1, 'auto', 0, '2025-11-25 21:20:50', '2025-11-26 12:35:26');

-- --------------------------------------------------------

--
-- Estrutura da tabela `product_affiliates`
--

CREATE TABLE `product_affiliates` (
  `id` int NOT NULL,
  `product_id` int NOT NULL,
  `affiliate_id` int NOT NULL,
  `status` enum('pending','approved','rejected','blocked') DEFAULT 'pending',
  `custom_commission` decimal(5,2) DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `approved_by` int DEFAULT NULL,
  `notes` text,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Extraindo dados da tabela `product_affiliates`
--

INSERT INTO `product_affiliates` (`id`, `product_id`, `affiliate_id`, `status`, `custom_commission`, `approved_at`, `approved_by`, `notes`, `created_at`, `updated_at`) VALUES
(0, 1, 5, 'approved', NULL, NULL, NULL, NULL, '2025-11-25 21:04:04', '2025-11-25 21:04:04'),
(0, 2, 5, 'approved', NULL, NULL, NULL, NULL, '2025-11-25 21:21:42', '2025-11-25 21:21:42'),
(0, 1, 7, 'approved', NULL, NULL, NULL, NULL, '2025-11-26 01:20:53', '2025-11-26 01:20:53'),
(0, 2, 7, 'approved', NULL, NULL, NULL, NULL, '2025-11-26 12:06:55', '2025-11-26 12:06:55');

--
-- Acionadores `product_affiliates`
--
DELIMITER $$
CREATE TRIGGER `after_product_affiliate_approved` AFTER UPDATE ON `product_affiliates` FOR EACH ROW BEGIN
    -- Quando o status muda para 'approved' e ainda não existe link
    IF NEW.status = 'approved' AND OLD.status != 'approved' THEN
        INSERT IGNORE INTO affiliate_links (affiliate_id, product_id, affiliate_code, link_url, click_count)
        VALUES (
            NEW.affiliate_id, 
            NEW.product_id,
            LOWER(HEX(RANDOM_BYTES(6))),
            CONCAT('https://scriptschool.com.br/digital/track_click.php?product_id=', NEW.product_id, '&affiliate=', NEW.affiliate_id),
            0
        );
    END IF;
END
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `after_product_affiliate_insert` AFTER INSERT ON `product_affiliates` FOR EACH ROW BEGIN
    -- Se já for aprovado na criação, cria o link
    IF NEW.status = 'approved' THEN
        INSERT INTO affiliate_links (affiliate_id, product_id, affiliate_code, link_url, click_count)
        VALUES (
            NEW.affiliate_id, 
            NEW.product_id,
            LOWER(HEX(RANDOM_BYTES(6))),
            CONCAT('https://scriptschool.com.br/digital/track_click.php?product_id=', NEW.product_id, '&affiliate=', NEW.affiliate_id),
            0
        );
    END IF;
END
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `after_product_affiliate_update` AFTER UPDATE ON `product_affiliates` FOR EACH ROW BEGIN
    -- Quando o status muda para 'approved'
    IF NEW.status = 'approved' AND OLD.status != 'approved' THEN
        INSERT IGNORE INTO affiliate_links (affiliate_id, product_id, affiliate_code, link_url, click_count)
        VALUES (
            NEW.affiliate_id, 
            NEW.product_id,
            LOWER(HEX(RANDOM_BYTES(6))),
            CONCAT('https://scriptschool.com.br/digital/track_click.php?product_id=', NEW.product_id, '&affiliate=', NEW.affiliate_id),
            0
        );
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Estrutura da tabela `product_report`
--

CREATE TABLE `product_report` (
  `id` int DEFAULT NULL,
  `name` varchar(200) DEFAULT NULL,
  `price` decimal(10,2) DEFAULT NULL,
  `sale_count` int DEFAULT NULL,
  `view_count` int DEFAULT NULL,
  `category_name` varchar(100) DEFAULT NULL,
  `producer_name` varchar(100) DEFAULT NULL,
  `total_affiliates` bigint DEFAULT NULL,
  `total_revenue` decimal(32,2) DEFAULT NULL,
  `average_sale_price` decimal(14,6) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estrutura da tabela `product_reviews`
--

CREATE TABLE `product_reviews` (
  `id` int NOT NULL,
  `product_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `customer_name` varchar(100) NOT NULL,
  `customer_email` varchar(150) NOT NULL,
  `rating` tinyint NOT NULL,
  `title` varchar(200) DEFAULT NULL,
  `comment` text,
  `is_approved` tinyint(1) DEFAULT '0',
  `approved_by` int DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estrutura da tabela `product_views`
--

CREATE TABLE `product_views` (
  `id` int NOT NULL,
  `product_id` int NOT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text,
  `referrer` varchar(500) DEFAULT NULL,
  `session_id` varchar(100) DEFAULT NULL,
  `viewed_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estrutura da tabela `sales`
--

CREATE TABLE `sales` (
  `id` int NOT NULL,
  `product_id` int NOT NULL,
  `affiliate_id` int DEFAULT NULL,
  `customer_name` varchar(100) NOT NULL,
  `customer_email` varchar(150) NOT NULL,
  `customer_phone` varchar(20) DEFAULT NULL,
  `customer_document` varchar(20) DEFAULT NULL,
  `customer_ip` varchar(45) DEFAULT NULL,
  `transaction_id` varchar(100) NOT NULL,
  `order_id` varchar(50) DEFAULT NULL,
  `amount` decimal(10,2) NOT NULL,
  `net_amount` decimal(10,2) NOT NULL,
  `commission_amount` decimal(10,2) DEFAULT '0.00',
  `tax_amount` decimal(10,2) DEFAULT '0.00',
  `payment_method` enum('pix','credit_card','boleto','debit_card','bank_transfer') NOT NULL,
  `payment_installments` int DEFAULT '1',
  `status` enum('pending','paid','refunded','cancelled','chargeback','expired') DEFAULT 'pending',
  `paid_at` datetime DEFAULT NULL,
  `refunded_at` datetime DEFAULT NULL,
  `access_expires_at` datetime DEFAULT NULL,
  `download_count` int DEFAULT '0',
  `last_download_at` datetime DEFAULT NULL,
  `affiliate_credited` tinyint(1) DEFAULT '0',
  `notes` text,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Extraindo dados da tabela `sales`
--

INSERT INTO `sales` (`id`, `product_id`, `affiliate_id`, `customer_name`, `customer_email`, `customer_phone`, `customer_document`, `customer_ip`, `transaction_id`, `order_id`, `amount`, `net_amount`, `commission_amount`, `tax_amount`, `payment_method`, `payment_installments`, `status`, `paid_at`, `refunded_at`, `access_expires_at`, `download_count`, `last_download_at`, `affiliate_credited`, `notes`, `created_at`, `updated_at`) VALUES
(1, 2, NULL, 'Cliente', 'test_user_80507629@testuser.com', NULL, NULL, NULL, 'MP_1342741509', NULL, 42.00, 29.40, 12.60, 0.00, 'credit_card', 1, 'paid', '2025-11-26 09:35:26', NULL, '2025-12-26 09:35:26', 0, NULL, 0, NULL, '2025-11-26 12:35:26', '2025-11-26 12:35:26'),
(2, 1, NULL, 'Cliente', 'test_user_80507629@testuser.com', NULL, NULL, NULL, 'MP_1325492962', NULL, 11.00, 7.70, 3.30, 0.00, 'credit_card', 1, 'paid', '2025-11-26 10:13:54', NULL, '2025-12-26 10:13:54', 0, NULL, 0, NULL, '2025-11-26 13:13:54', '2025-11-26 13:13:54'),
(3, 1, NULL, 'Cliente', 'test_user_80507629@testuser.com', NULL, NULL, NULL, 'MP_1325492480', NULL, 11.00, 7.70, 3.30, 0.00, 'credit_card', 1, 'paid', '2025-11-26 10:21:10', NULL, '2025-12-26 10:21:10', 0, NULL, 0, NULL, '2025-11-26 13:21:10', '2025-11-26 13:21:10'),
(4, 1, NULL, 'Cliente', 'test_user_80507629@testuser.com', NULL, NULL, NULL, 'MP_1325493248', NULL, 11.00, 7.70, 3.30, 0.00, 'credit_card', 1, 'paid', '2025-11-26 10:48:53', NULL, '2025-12-26 10:48:53', 0, NULL, 0, NULL, '2025-11-26 13:48:53', '2025-11-26 13:48:53');

-- --------------------------------------------------------

--
-- Estrutura da tabela `settings`
--

CREATE TABLE `settings` (
  `id` int NOT NULL,
  `setting_key` varchar(100) NOT NULL,
  `setting_value` text,
  `setting_type` enum('string','number','boolean','json') DEFAULT 'string',
  `description` text,
  `is_public` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Extraindo dados da tabela `settings`
--

INSERT INTO `settings` (`id`, `setting_key`, `setting_value`, `setting_type`, `description`, `is_public`, `created_at`, `updated_at`) VALUES
(1, 'site_name', 'DigitalStore', 'string', 'Nome do site', 1, '2025-11-18 13:25:25', '2025-11-18 13:25:25'),
(2, 'site_description', 'Plataforma de venda de produtos digitais', 'string', 'Descrição do site', 1, '2025-11-18 13:25:25', '2025-11-18 13:25:25'),
(3, 'currency', 'BRL', 'string', 'Moeda padrão', 1, '2025-11-18 13:25:25', '2025-11-18 13:25:25'),
(4, 'currency_symbol', 'R$', 'string', 'Símbolo da moeda', 1, '2025-11-18 13:25:25', '2025-11-18 13:25:25'),
(5, 'default_commission', '30', 'number', 'Comissão padrão para afiliados (%)', 0, '2025-11-18 13:25:25', '2025-11-18 13:25:25'),
(6, 'affiliate_approval', 'auto', 'string', 'Tipo de aprovação de afiliados (auto/manual)', 0, '2025-11-18 13:25:25', '2025-11-18 13:25:25'),
(7, 'payout_minimum', '50', 'number', 'Valor mínimo para saque', 0, '2025-11-18 13:25:25', '2025-11-18 13:25:25'),
(8, 'tax_percentage', '0', 'number', 'Percentual de imposto sobre vendas', 0, '2025-11-18 13:25:25', '2025-11-18 13:25:25'),
(9, 'email_notifications', '1', 'boolean', 'Habilitar notificações por email', 0, '2025-11-18 13:25:25', '2025-11-18 13:25:25'),
(10, 'file_storage', 'local', 'string', 'Sistema de armazenamento de arquivos', 0, '2025-11-18 13:25:25', '2025-11-18 13:25:25');

-- --------------------------------------------------------

--
-- Estrutura da tabela `support_attachments`
--

CREATE TABLE `support_attachments` (
  `id` int NOT NULL,
  `reply_id` int NOT NULL,
  `file_name` varchar(200) NOT NULL,
  `file_path` varchar(500) NOT NULL,
  `file_size` bigint DEFAULT NULL,
  `mime_type` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estrutura da tabela `support_replies`
--

CREATE TABLE `support_replies` (
  `id` int NOT NULL,
  `ticket_id` int NOT NULL,
  `user_id` int NOT NULL,
  `message` text NOT NULL,
  `is_internal` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estrutura da tabela `support_tickets`
--

CREATE TABLE `support_tickets` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `sale_id` int DEFAULT NULL,
  `subject` varchar(200) NOT NULL,
  `message` text NOT NULL,
  `status` enum('open','answered','closed','pending') DEFAULT 'open',
  `priority` enum('low','medium','high','urgent') DEFAULT 'medium',
  `assigned_to` int DEFAULT NULL,
  `last_reply_at` datetime DEFAULT NULL,
  `closed_at` datetime DEFAULT NULL,
  `closed_by` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estrutura da tabela `system_logs`
--

CREATE TABLE `system_logs` (
  `id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `action` varchar(100) NOT NULL,
  `description` text,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text,
  `context` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estrutura da tabela `users`
--

CREATE TABLE `users` (
  `id` int NOT NULL,
  `name` varchar(100) NOT NULL,
  `email` varchar(150) NOT NULL,
  `password` varchar(255) NOT NULL,
  `user_type` enum('producer','affiliate','admin','member') NOT NULL DEFAULT 'affiliate',
  `status` enum('active','inactive','suspended') DEFAULT 'active',
  `cpf` varchar(14) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `avatar_url` varchar(500) DEFAULT NULL,
  `bio` text,
  `website` varchar(200) DEFAULT NULL,
  `bank_name` varchar(100) DEFAULT NULL,
  `bank_agency` varchar(10) DEFAULT NULL,
  `bank_account` varchar(20) DEFAULT NULL,
  `bank_type` enum('checking','savings') DEFAULT 'checking',
  `bank_pix` varchar(100) DEFAULT NULL,
  `email_verified` tinyint(1) DEFAULT '0',
  `verification_token` varchar(100) DEFAULT NULL,
  `reset_token` varchar(100) DEFAULT NULL,
  `reset_expires` datetime DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Extraindo dados da tabela `users`
--

INSERT INTO `users` (`id`, `name`, `email`, `password`, `user_type`, `status`, `cpf`, `phone`, `avatar_url`, `bio`, `website`, `bank_name`, `bank_agency`, `bank_account`, `bank_type`, `bank_pix`, `email_verified`, `verification_token`, `reset_token`, `reset_expires`, `last_login`, `created_at`, `updated_at`) VALUES
(1, 'Administrador', 'admin@digitalstore.com', '$2y$10$//l0VicUYmTjRUQgr24fDO0zpf5x0Dn9.cRrg7dtX79w35AWF34Vq', 'admin', 'active', '000.000.000-00', '(11) 99999-9999', NULL, NULL, NULL, NULL, NULL, NULL, 'checking', NULL, 0, NULL, NULL, NULL, NULL, '2025-11-18 13:25:25', '2025-11-22 14:19:45'),
(2, 'THIAGO LOPES DE OLIVEIRA', 'xpcomputadores123@gmail.com', '$2y$10$//l0VicUYmTjRUQgr24fDO0zpf5x0Dn9.cRrg7dtX79w35AWF34Vq', 'producer', 'active', '053.657.136-80', '35997458988', NULL, '', '', '', '', '', 'checking', 'thiago@sammhost.com', 0, NULL, NULL, NULL, NULL, '2025-11-18 13:27:34', '2025-11-23 19:13:24'),
(3, 'CREAM DI VANILLA', 'thiagolopes_oliveira@hotmail.com', '$2y$10$BiWVwSBmfOT4SdUw8Ez8YuZIHKyaIYHsJjFiZGsnRXozXS3vMjid6', 'affiliate', 'active', '05141836673', '35997051347', NULL, NULL, NULL, NULL, NULL, NULL, 'checking', NULL, 0, NULL, NULL, NULL, NULL, '2025-11-19 00:51:55', '2025-11-19 00:51:55'),
(4, 'CREAM DI VANILLA', 'admin@tlmarketing.com.br', '$2y$10$7G5ukQquib5o4hg8Af/Ot.JADBfOmfHtDEZ7CroYNJLIYaRg8D3ei', 'affiliate', 'active', '053.657.136-84', '35998088942', NULL, NULL, NULL, NULL, NULL, NULL, 'checking', NULL, 0, NULL, NULL, NULL, NULL, '2025-11-19 02:51:53', '2025-11-19 02:51:53'),
(5, 'admin', 'admin@admin.com', '$2y$10$lGCU5PGvQ2LM0u.RvL1hd.BtVtVt51P2aEAE8bjme.Gq4JmQSQL4m', 'affiliate', 'active', '053.657.136-80', '35998088942', NULL, '', '', '', '', '', 'checking', 'thiago@sammhost.com', 0, NULL, NULL, NULL, NULL, '2025-11-19 12:03:32', '2025-11-21 00:18:34'),
(6, 'admin1', 'admin1@admin.com', '$2y$10$GTf32pmaz0D5k4lz3hZEaOIpN9cGRY9jPBFyH/JxLLPWW/hej9PCW', 'producer', 'active', '54154546416', '553598361802', NULL, NULL, NULL, NULL, NULL, NULL, 'checking', NULL, 0, NULL, NULL, NULL, NULL, '2025-11-20 13:10:10', '2025-11-20 13:10:10'),
(7, 'EDUARDA DE OLIVEIRA', 'dudu@dudu.com', '$2y$10$SYcwSHoBkMMVg5ze8iMDZuGHP8K4hIEsKcQ1nZGY1zG3grTe7gcmS', 'affiliate', 'active', '05141836673', '35998361802', NULL, '', '', '', '', '', 'checking', 'thiago@sammhost.com', 0, NULL, NULL, NULL, NULL, '2025-11-23 15:02:03', '2025-11-23 18:25:51'),
(8, 'GISELLE APARECIDA DA SILVA', 'thiagolopeso@hotmail.com', '$2y$10$/HpcRUF5IRKNdHj1w8ygJOwWBgpACZjC9JnrNmsPlSjk6pCu.9hq2', 'member', 'active', '05141836673', '110100000201212', NULL, NULL, NULL, NULL, NULL, NULL, 'checking', NULL, 0, NULL, NULL, NULL, NULL, '2025-11-23 22:31:25', '2025-11-23 22:31:25'),
(9, 'lucia lopes', 'test_user_80507629@testuser.com', '$2y$10$KHQi8AsiYo4h0XYyw4ET4u79DHpxVztPHg0R7Wg0BTxWzD9KIdniq', 'member', 'active', '0000665656565', '35987085995', NULL, NULL, NULL, NULL, NULL, NULL, 'checking', NULL, 0, NULL, NULL, NULL, NULL, '2025-11-23 23:53:20', '2025-11-23 23:56:57');

--
-- Índices para tabelas despejadas
--

--
-- Índices para tabela `affiliate_links`
--
ALTER TABLE `affiliate_links`
  ADD PRIMARY KEY (`id`);

--
-- Índices para tabela `categories`
--
ALTER TABLE `categories`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `slug_unique` (`slug`);

--
-- Índices para tabela `products`
--
ALTER TABLE `products`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `slug` (`slug`);

--
-- Índices para tabela `sales`
--
ALTER TABLE `sales`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `transaction_id` (`transaction_id`);

--
-- AUTO_INCREMENT de tabelas despejadas
--

--
-- AUTO_INCREMENT de tabela `affiliate_links`
--
ALTER TABLE `affiliate_links`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=22;

--
-- AUTO_INCREMENT de tabela `categories`
--
ALTER TABLE `categories`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT de tabela `products`
--
ALTER TABLE `products`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT de tabela `sales`
--
ALTER TABLE `sales`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
